/*
 * ContinuousValue.hpp
 *
 *  Created on: Sep 28, 2011
 *      Author: heber
 */

#ifndef CONTINUOUSVALUE_HPP_
#define CONTINUOUSVALUE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Range.hpp"

#include "ValueInterface.hpp"

class ContinuousValueTest;

/** This class represents a discrete value, it implements ValueInterface.
 *
 */
template <class T>
class ContinuousValue : virtual public ValueInterface<T>
{
  //!> unit test needs to have access to internal values
  friend class ContinuousValueTest;
public:
  ContinuousValue();
  ContinuousValue(const range<T> &_ValidRange);
  virtual ~ContinuousValue();

  // functions for ValueInterface
  bool isValid(const T & _value) const;
  const T & get() const;
  void set(const T & _value);

  // comfortable setter
  void operator=(const T &_value)
  { set(_value);  }

  // comparator
  bool operator==(const ContinuousValue<T> &_instance) const;
  bool operator!=(const ContinuousValue<T> &_instance) const
      { return !((*this)==(_instance)); }

  // getter/setter for valid ranges
  void setValidRange(const range<T> &_range);
  const range<T> & getValidRange() const;

  // internal functions alike to ValueInterface
  bool isValidValue(const T &_value) const;
  void setValue(const T &_value);
  const T &getValue() const;

private:
  //!> whether \a value has been set
  bool ValueSet;
  //!> contained value
  T value;

  //!> whether \a min, i.e. a minimal value, has been set
  range<bool> ValidRangeSet;
  //!> valid range of values
  range<T> ValidRange;
};

#include "ContinuousValue_impl.hpp"

#endif /* CONTINUOUSVALUE_HPP_ */
