/*
 * GetNextJobIdOperation.hpp
 *
 *  Created on: Feb 16, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_
#define FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>

#include "Connection.hpp"

#include "JobId.hpp"
#include "Operations/AsyncOperation.hpp"
#include "types.hpp"

/** This Operations requests number of present jobs and present results (done
 * jobs) from the server.
 *
 */
class GetNextJobIdOperation : public AsyncOperation  {
public:
  /// Constructor for class GetNextJobIdOperation.
  GetNextJobIdOperation(Connection &_connection) :
    AsyncOperation(std::string("getnextjobid"), _connection)
  {}
  /// Destructor for class GetNextJobIdOperation
  ~GetNextJobIdOperation() {}

public:
  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when sending number of desired job ids.
  void handle_SendNumberIds(const boost::system::error_code& e);

  /// Callback function when new job ids have been received.
  void handle_ReceiveNextIds(const boost::system::error_code& e);

  /// setter for the desired number of ids on next connect
  void setDesiredIds(const size_t _number) {
    NumberIds = _number;
  }

  /// Getter for nextid
  size_t getNextId();

  /// checks whether nextids is empty
  bool isNextIdAvailable() const {
    return !nextids.empty();
  }

protected:
  /// Callback function when Operations finishes.
  void handle_FinishOperation(const boost::system::error_code& e);

private:
  //!> number of desired job ids
  size_t NumberIds;

  //!> temporary for a bunch of received ids
  std::vector<JobId_t> ids;

  //!> number of received job ids
  std::list<JobId_t> nextids;
};

#endif /* FRAGMENTCONTROLLER_GETNEXTJOBIDOPERATION_HPP_ */
