/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Shape_HomogeneousPointsUnitTest.cpp
 *
 *  Created on: Jun 19, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cmath>
#include <limits>
#include <vector>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "CodePatterns/Assert.hpp"

#include "LinearAlgebra/Vector.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/Shape.hpp"

#include "Shape_HomogeneousPointsUnitTest.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( Shape_HomogeneousPointsTest );

void Shape_HomogeneousPointsTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);
}

void Shape_HomogeneousPointsTest::tearDown()
{}

/** Unit test for points on Shape's surface.
 *
 */
void Shape_HomogeneousPointsTest::surfaceTest()
{
  {
    Shape s = Sphere();
    std::vector<Vector> nodes = s.getHomogeneousPointsOnSurface(12);
    CPPUNIT_ASSERT_EQUAL( (size_t)12, nodes.size());
    for (size_t i=0;i<12;++i)
      CPPUNIT_ASSERT( s.isOnSurface(nodes[i]) );
  }
  {
    Shape s = Sphere(zeroVec, 2.);
    std::vector<Vector> nodes = s.getHomogeneousPointsOnSurface(12);
    CPPUNIT_ASSERT_EQUAL( (size_t)12, nodes.size());
    for (size_t i=0;i<12;++i)
      CPPUNIT_ASSERT( s.isOnSurface(nodes[i]) );
  }
}

/** Unit test for points in Shape's volume.
 *
 */
void Shape_HomogeneousPointsTest::volumeTest()
{
  // is not implemented
//  Shape s = Sphere();
//  std::vector<Vector> nodes = s.getHomogeneousPointsInVolume(12);
//  CPPUNIT_ASSERT_EQUAL( (size_t)12, nodes.size());
//  for (size_t i=0;i<12;++i)
//    CPPUNIT_ASSERT( s.isInside(nodes[i]) );
}
