/*
 * ShapeOps_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPEOPS_IMPL_HPP_
#define SHAPEOPS_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Shapes/Shape_impl.hpp"
#include "Shapes/ShapeExceptions.hpp"
#include "Shapes/ShapeType.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

#include <vector>

class LineSegment;

class ShapeOpsBase_impl : public Shape_impl{
public:
  ShapeOpsBase_impl(const Shape::impl_ptr&);
  virtual ~ShapeOpsBase_impl();
  virtual bool isInside(const Vector &point) const;
  virtual bool isOnSurface(const Vector &point) const;
  virtual Vector getNormal(const Vector &point) const throw (NotOnSurfaceException);
  virtual Vector getCenter() const;
  virtual double getRadius() const;
  virtual LineSegmentSet getLineIntersections(const Line&) const;
  virtual enum ShapeType getType() const;
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
  virtual std::vector<Vector> getHomogeneousPointsInVolume(const size_t N) const;
protected:
  virtual Vector translateIn(const Vector &point) const=0;
  virtual Vector translateOutPos(const Vector &point) const=0;
  virtual Vector translateOutNormal(const Vector &point) const=0;
  Shape::impl_ptr getArg() const;
private:
  Shape::impl_ptr arg;
};

class Resize_impl :  public ShapeOpsBase_impl
{
public:
  Resize_impl(const Shape::impl_ptr&,double);
  virtual ~Resize_impl();
protected:
  virtual double getVolume() const;
  virtual double getSurfaceArea() const;
  virtual Vector translateIn(const Vector &point) const;
  virtual Vector translateOutPos(const Vector &point) const;
  virtual Vector translateOutNormal(const Vector &point) const;
  virtual std::string toString() const;
  virtual bool isInside(const Vector& point) const;
private:
  double size;
};

class Translate_impl :  public ShapeOpsBase_impl
{
public:
  Translate_impl(const Shape::impl_ptr&, const Vector&);
  virtual ~Translate_impl();
protected:
  virtual Vector getCenter() const;
  virtual double getRadius() const;
  virtual double getVolume() const;
  virtual double getSurfaceArea() const;
  virtual Vector translateIn(const Vector &point) const;
  virtual Vector translateOutPos(const Vector &point) const;
  virtual Vector translateOutNormal(const Vector &point) const;
  virtual std::string toString() const;
  virtual bool isInside(const Vector& point) const;
private:
  Vector offset;
};

class Stretch_impl : public ShapeOpsBase_impl
{
public:


	Stretch_impl(const Shape::impl_ptr&, const Vector&);
  virtual ~Stretch_impl();
protected:
  virtual double getVolume() const;
  virtual double getSurfaceArea() const;
  virtual Vector translateIn(const Vector &point) const;
  virtual Vector translateOutPos(const Vector &point) const;
  virtual Vector translateOutNormal(const Vector &point) const;
  virtual std::string toString() const;
  virtual bool isInside(const Vector& point) const;
private:
  Vector factors;
  Vector reciFactors;
};

class Transform_impl : public ShapeOpsBase_impl
{
public:
  Transform_impl(const Shape::impl_ptr&, const RealSpaceMatrix&);
  virtual ~Transform_impl();
protected:
  virtual double getVolume() const;
  virtual double getSurfaceArea() const;
  virtual Vector translateIn(const Vector &point) const;
  virtual Vector translateOutPos(const Vector &point) const;
  virtual Vector translateOutNormal(const Vector &point) const;
  virtual std::string toString() const;
  virtual bool isInside(const Vector& point) const;
private:
  RealSpaceMatrix transformation;
  RealSpaceMatrix transformationInv;
};

#endif /* SHAPEOPS_IMPL_HPP_ */
