/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MoleculeOfAtomSelectionDescriptor.cpp
 *
 *  Created on: Dec 11, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Descriptors/MoleculeOfAtomSelectionDescriptor.hpp"
#include "Descriptors/MoleculeOfAtomSelectionDescriptor_impl.hpp"

#include "Helpers/helpers.hpp"

#include "molecule.hpp"
#include "World.hpp"

MoleculeOfAtomSelectionDescriptor_impl::MoleculeOfAtomSelectionDescriptor_impl(){}

MoleculeOfAtomSelectionDescriptor_impl::~MoleculeOfAtomSelectionDescriptor_impl(){}

bool MoleculeOfAtomSelectionDescriptor_impl::predicate(std::pair<moleculeId_t,molecule*> molecule){
  for (molecule::const_iterator iter = molecule.second->begin();
      iter != molecule.second->end();
      ++iter) {
    if (World::getInstance().isSelected(*iter))
      return true;
  }
  return false;
}

molecule* MoleculeOfAtomSelectionDescriptor_impl::find(){
  World &instance = World::getInstance();
  for (World::AtomSelectionIterator iter = instance.beginAtomSelection();
      iter != instance.endAtomSelection();
      ++iter) {
    if (iter->second->getMolecule() != NULL)
      return iter->second->getMolecule();
  }
  return 0;
}

std::vector<molecule*> MoleculeOfAtomSelectionDescriptor_impl::findAll(){
  std::vector<molecule*> res;
  std::set<molecule*> temp;
  std::pair< std::set<molecule*>::iterator, bool> inserter;
  World &instance = World::getInstance();
  for (World::AtomSelectionIterator iter = instance.beginAtomSelection();
      iter != instance.endAtomSelection();
      ++iter) {
    if (iter->second->getMolecule() != NULL) {
      inserter = temp.insert( iter->second->getMolecule() );
      if (inserter.second)
        res.push_back(iter->second->getMolecule());
    }
  }
  return res;
}

MoleculeDescriptor MoleculesByAtomSelection(){
  return MoleculeDescriptor(MoleculeDescriptor::impl_ptr(new MoleculeOfAtomSelectionDescriptor_impl()));
}
