/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MPQCFragmentController.cpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

//#include "CodePatterns/MemDebug.hpp"

#include "MPQCFragmentController.hpp"

#include <boost/cast.hpp>
#include <boost/filesystem/operations.hpp>

#include "Box.hpp"
#include "Helpers/defs.hpp"
#include "Fragmentation/Automation/FragmentJobQueue.hpp"
#include "Jobs/MPQCJob.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"

bool MPQCFragmentController::addJobsFromQueue(
    const MPQCData::DoLongrange_t _DoLongrange,
    const MPQCData::DoValenceOnly_t _DoValenceOnly,
    const int _verbose
    )
{
  bool status = true;
  // give them all valid ids
  std::vector<FragmentJob::ptr> newjobs = FragmentJobQueue::getInstance().getJobs();
  for (std::vector<FragmentJob::ptr>::iterator jobiter = newjobs.begin();
      jobiter != newjobs.end();
      ++jobiter) {
    MPQCJob *job = boost::polymorphic_downcast<MPQCJob *>(jobiter->get());
    job->DoLongrange = _DoLongrange;
    job->DoValenceOnly = _DoValenceOnly;
    job->verbose = _verbose;
    JobId_t id = getAvailableId();
    if (id == (JobId_t)JobId::IllegalJob) {
      status = false;
      break;
    }
    changeJobId((*jobiter), id);
  }
  // add the jobs
  if (status)
    addJobs(newjobs);
  status &= (newjobs.size() != 0);

  return status;
}

void MPQCFragmentController::run()
{
  // take jobs from queue and add them
  sendJobs(host, port);
  RunService("Adding MPQCJobs");
}
