/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RotateAroundOriginByAngleAction.cpp
 *
 *  Created on: Aug 06, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "molecule.hpp"


#include <cmath>
#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/AtomAction/RotateAroundOriginByAngleAction.hpp"

// and construct the stuff
#include "RotateAroundOriginByAngleAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomRotateAroundOriginByAngleAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  // obtain information
  getParametersfromValueStorage();

  // check whether Axis is valid
  if (params.Axis.IsZero())
    return Action::failure;

  // convert from degrees to radian
  params.angle *= M_PI/180.;

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), params.Axis);

  DoLog(0) && (Log() << Verbose(0) << "Rotate around origin by " << params.angle << " radian, axis from origin to " << params.Axis << "." << endl);
  // TODO: use AtomSet::rotate?
  for (std::vector<atom *>::iterator iter = selectedAtoms.begin(); iter != selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), params.angle));
  }
  DoLog(0) && (Log() << Verbose(0) << "done." << endl);
  return Action::state_ptr(new AtomRotateAroundOriginByAngleState(World::getInstance().getSelectedAtoms(), params));
}

Action::state_ptr AtomRotateAroundOriginByAngleAction::performUndo(Action::state_ptr _state) {
  AtomRotateAroundOriginByAngleState *state = assert_cast<AtomRotateAroundOriginByAngleState*>(_state.get());

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), state->params.Axis);

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), -state->params.angle));
  }

  return Action::state_ptr(_state);
}

Action::state_ptr AtomRotateAroundOriginByAngleAction::performRedo(Action::state_ptr _state){
  AtomRotateAroundOriginByAngleState *state = assert_cast<AtomRotateAroundOriginByAngleState*>(_state.get());

  // Creation Line that is the rotation axis
  Line RotationAxis(Vector(0.,0.,0.), state->params.Axis);

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    (*iter)->setPosition(RotationAxis.rotateVector((*iter)->getPosition(), state->params.angle));
  }

  return Action::state_ptr(_state);
}

bool AtomRotateAroundOriginByAngleAction::canUndo() {
  return true;
}

bool AtomRotateAroundOriginByAngleAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
