#!/bin/bash

read -d '' CHANGEME << "EOF"

# start service in background
${AUTOTEST_PATH}/molecuilder_server --signal 2 --workerport $WORKERPORT --controllerport $CONTROLLERPORT &
server_pid=$!
AT_CHECK([sleep 2], 0, [ignore], [ignore], [kill $server_pid])
AT_CHECK([kill -s 0 $server_pid], 0, [ignore], [ignore], [kill $server_pid])

# enlist a worker to work on jobs
../../molecuilder_mpqc +v 5 ++signal 2 ++server 127.0.0.1:${WORKERPORT} ++hostname 127.0.0.1 ++listen $WORKERLISTENPORT &
worker_pid=$!
AT_CHECK([sleep 2], 0, [ignore], [ignore], [kill $server_pid $worker_pid])
AT_CHECK([kill -s 0 $worker_pid], 0, [ignore], [ignore], [kill $server_pid $worker_pid])
EOF

read -d '' CHANGETOO << "EOF"

# send removeall to server such that all workers shutdown
AT_CHECK([${AUTOTEST_PATH}/molecuilder_controller --server 127.0.0.1:$CONTROLLERPORT --command removeall], 0, [ignore], [ignore], [kill $server_pid $worker_pid])

# shutdown controller socket 
AT_CHECK([${AUTOTEST_PATH}/molecuilder_controller --server 127.0.0.1:$CONTROLLERPORT --command shutdown], 0, [stdout], [ignore], [kill $server_pid $worker_pid])

# check that worker is truly down
AT_CHECK([sleep 1], 0, [ignore], [ignore], [kill $server_pid $worker_pid])
AT_CHECK([kill $worker_pid], 1, [ignore], [ignore], [kill $server_pid])

# check that server is truly down
AT_CHECK([sleep 1], 0, [ignore], [ignore], [kill $server_pid])
AT_CHECK([kill $server_pid], 1, [ignore], [ignore])

# check calculated energy
AT_CHECK([cat energy_stdout | awk -v energy=$ENERGY 'function abs(x){return ((x < 0.0) ? -x : x)} {if (abs(($1 - energy)/energy) > 1e-5) exit(1)}'], 0, [stdout], [stderr])
EOF

wport=3000
for file in `find . -name 'testsuite-calculations-*.at'`; do

newfilename=`echo "$file" | sed -e "s#-calculations-#-calculations-jobmarket-#"`


let cport=$wport+1
let lport=$cport+1

firstline=` grep -n AT_SKIP $file | awk -F":" '{print $1}'`
secondline=` grep -n "AT_CHECK(\[cat stdout" $file | awk -F":" '{print $1}'`

sed -e "${firstline},1000d" $file >$newfilename
echo -e "\n# check that ports are unique over all tests such that they may run in parallel\nWORKERPORT=${wport}\nCONTROLLERPORT=${cport}\nWORKERLISTENPORT=${lport}\n" >>$newfilename
echo "$CHANGEME" >>$newfilename
sed -e "${secondline},1000d" -e "1,${firstline}d" -e "s#fragment-automation\(.*\)#fragment-automation --server-address 127.0.0.1 --server-port \$CONTROLLERPORT --DoLongrange 0 \1#" -e "/^.*--fragment-executable.*$/d" -e "/^.*--save-fragment-results.*$/d" -e "s#\(fragment-prefix .*\) \\\#\1],#" -e "s#\(exit(1)}'\], 0\)#\1, [stdout], [stderr]#" -e "s#\(0, \[stdout\], \[stderr\]\))#\1, [kill \$server_pid \$worker_pid])#" -e "s#awk '{print \$2}'#awk '{print \$2}' >energy_stdout#" $file >>$newfilename
echo -e "\n$CHANGETOO" >>$newfilename
sed -e "1,${secondline}d" $file >>$newfilename

let wport=$wport+10

done
