/*
 * ExportGraph_ToJobs.hpp
 *
 *  Created on: 08.03.2012
 *      Author: heber
 */

#ifndef EXPORTGRAPH_TOJOBS_HPP_
#define EXPORTGRAPH_TOJOBS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Fragmentation/Exporters/ExportGraph.hpp"

/** ExportGraph_ToJobs implements an ExportGraph by sending the created
 * configurations of fragmentary systems as jobs to a server.
 *
 */
class ExportGraph_ToJobs : public ExportGraph
{
public:
  /** Constructor for ExportGraph_ToJobs.
   *
   * Sets default level.
   *
   * \param _graph Graph with all KeySet's
   * \param _treatment whether hydrogen is excluded in the _graph or not
   * \param _saturation whether we saturate dangling bonds or not
   * \param _globalsaturationpositions possibly empty map with global information
   *        where to place saturation hydrogens to fulfill consistency principle
   */
  ExportGraph_ToJobs(
      const Graph &_graph,
      const enum HydrogenTreatment _treatment,
      const enum HydrogenSaturation _saturation,
      const SaturatedFragment::GlobalSaturationPositions_t &_globalsaturationpositions);
  virtual ~ExportGraph_ToJobs();

	bool operator()();

  /** Sets the level for the sampling of the density.
   *
   * \param _level level to set
   */
  void setLevel(const size_t _level) { level = _level; }

private:
  //!> resolution of sampled electron density as \f$2^{\mathrm{level}}\f$
  size_t level;
};

#endif /* EXPORTGRAPH_TOJOBS_HPP_ */
