/*
 * ExportGraph_ToFiles.hpp
 *
 *  Created on: 08.03.2012
 *      Author: heber
 */

#ifndef EXPORTGRAPH_TOFILES_HPP_
#define EXPORTGRAPH_TOFILES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Fragmentation/Exporters/ExportGraph.hpp"
#include "Fragmentation/SortIndex.hpp"

class ListOfLocalAtoms_t;
class molecule;

/** ExportGraph_ToFiles implements an ExportGraph as storing all fragmentary
 * systems to files.
 */
class ExportGraph_ToFiles : public ExportGraph
{
public:
	ExportGraph_ToFiles(
	    const Graph &_graph,
	    const enum HydrogenTreatment _treatment,
	    const enum HydrogenSaturation _saturation,
      const SaturatedFragment::GlobalSaturationPositions_t &_globalsaturationpositions);
	virtual ~ExportGraph_ToFiles();

	bool operator()();

	void setPrefix(const std::string &_prefix) {
	  prefix = _prefix;
	}

	void setOutputTypes(const std::vector<std::string> &_typelist) {
	  typelist = _typelist;
	}

private:
	/** Helper function to store a fragment for all desired types to file.
	 *
	 * \param CurrentFragment SaturatedFragment to store to file
	 * \param FragmentNumber number padded with zeros used in filename
	 * \param FragmentCounter enumeration of this fragment
	 * \return true - file written successfully, false - writing failed
	 */
	bool storeFragmentForAllTypes(
	    SaturatedFragment_ptr &CurrentFragment,
	    char *FragmentNumber,
	    size_t FragmentCounter) const;

	/** Helper function to append the key sets in this SaturatedFragment without
	 * added hydrogens to an open stream.
	 *
	 * \param CurrentFragment fragment whose indices to write
   * \param ForcesFile open stream to write to
   * \param SortIndex Index to map from the BFS labeling to the sequence how of Ion_Type in the config
   * \return true - file written successfully, false - writing failed
   */
	bool appendToForcesFile(
	    SaturatedFragment_ptr &CurrentFragment,
	    std::ostream &ForcesFile,
	    const SortIndex_t &SortIndex) const;

private:
	//!> prefix for fragment files
	std::string prefix;
  //!> list of parser types for which a configuration file per fragment is stored
  std::vector<std::string> typelist;
};

#endif /* EXPORTGRAPH_TOFILES_HPP_ */
