/*
 * ExportGraph_ToAtomFragments.hpp
 *
 *  Created on: Mar 07, 2016
 *      Author: heber
 */

#ifndef EXPORTGRAPH_TOATOMFRAGMENTS_HPP_
#define EXPORTGRAPH_TOATOMFRAGMENTS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Fragmentation/Exporters/ExportGraph.hpp"

/** ExportGraph_ToAtomFragments implements an ExportGraph by sending the created
 * configurations of fragmentary systems as keysets and forcekeysets, i.e.
 * including excluded hydrogens, to AtomFragmentsMap.
 *
 */
class ExportGraph_ToAtomFragments : public ExportGraph
{
public:
  /** Constructor for ExportGraph_ToAtomFragments.
   *
   * Sets default level.
   *
   * \param _graph Graph with all KeySet's
   * \param _treatment whether hydrogen is excluded in the _graph or not
   * \param _saturation whether we saturate dangling bonds or not
   * \param _globalsaturationpositions possibly empty map with global information
   *        where to place saturation hydrogens to fulfill consistency principle
   */
  ExportGraph_ToAtomFragments(
      const Graph &_graph,
      const enum HydrogenTreatment _treatment,
      const enum HydrogenSaturation _saturation,
      const SaturatedFragment::GlobalSaturationPositions_t &_globalsaturationpositions);
  virtual ~ExportGraph_ToAtomFragments();

	bool operator()();
};

#endif /* EXPORTGRAPH_TOATOMFRAGMENTS_HPP_ */
