/*
 * MpqcParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef MPQCPARSER_HPP_
#define MPQCPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "FormatParser.hpp"
#include "MpqcParser_Parameters.hpp"

#include <iosfwd>

/**
 * Loads a MPQC config file into the World and saves the World as a tremolo file.
 */
class MpqcParser : public FormatParser
{
  friend class ParserMpqcUnitTest;
public:

  MpqcParser();
  virtual ~MpqcParser();
  void load(std::istream* file);
  void save(std::ostream* file, const std::vector<atom *> &atoms);

  /** Getter for parameter set.
   *
   * @return reference to parameter class
   */
  MpqcParser_Parameters & getParams() { return *static_cast<MpqcParser_Parameters *>(parameters); }
};


#endif /* MPQCPARSER_HPP_ */
