/*
 * FormatParser.hpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#ifndef FORMATPARSER_HPP_
#define FORMATPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CodePatterns/Observer.hpp"
#include "ChangeTracker.hpp"
#include "FormatParser_Parameters.hpp"
#include "parser.hpp"


class atom;

/**
 * General parser which observes the change tracker.
 */
class FormatParser : public Observer {
  friend class MoleculeLoadAction;
public:
  FormatParser();
  virtual ~FormatParser();
  virtual void save(std::ostream* file, const std::vector<atom *> &atoms)=0;
  virtual void load(std::istream* file)=0;
  void setOstream(std::ostream* file);

protected:
  void update(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);
  void subjectKilled(Observable *publisher);

  // these functions are called when atoms are inserted or removed
  virtual void AtomInserted(atomId_t) {};
  virtual void AtomRemoved(atomId_t) {};

  FormatParser_Parameters *parameters;
private:

  std::ostream* saveStream;
};

#endif /* FORMATPARSER_HPP_ */
