/*
 * RandomNumberDistributionFactory.hpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERDISTRIBUTIONFACTORY_HPP_
#define RANDOMNUMBERDISTRIBUTIONFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"

#include "RandomNumberDistribution.hpp"
#include "RandomNumberDistribution_Parameters.hpp"

// this defines stuff necessary PREVIOUS of PrototypeFactory.hpp inclusion
#include "RandomNumberDistributionFactory.def"
#include "CodePatterns/FactoryTypeList.hpp"
#include "RandomNumberDistributionFactory.undef"

#include "CodePatterns/ManipulablePrototypeFactory.hpp"

#include <map>

class RandomNumberDistributionFactoryUnitTest;
class CommandSetRandomNumbersDistributionAction;

/** This is the abstract factory class for random number distributions.
 *
 * The reason for creating the distributions as this is that we would like to set
 * the distributions parameters, via some Action, and then onward only have
 * random number distributions of this type using these parameters. Hence, we have
 * a singleton factory that is controlled by the Action and can then create
 * distributions wherever we like in the code by having the factory create one.
 *
 */
class RandomNumberDistributionFactory :
  public Singleton<RandomNumberDistributionFactory>,
  public ManipulablePrototypeFactory<RandomNumberDistribution, RandomNumberDistribution_Parameters>
{
  friend class Singleton<RandomNumberDistributionFactory>;
  friend class RandomNumberDistributionFactoryTest;
  friend class CommandSetRandomNumbersDistributionAction;

protected:
  void FillPrototypeTable();
  void EmptyPrototypeTable();

  RandomNumberDistributionFactory();
  virtual ~RandomNumberDistributionFactory();

};

#endif /* RANDOMNUMBERDISTRIBUTIONFACTORY_HPP_ */
