#ifndef PERIODENTAFEL_HPP_
#define PERIODENTAFEL_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class element;

/********************************************** declarations *******************************/


/** Periodentafel is a list of all elements sorted by their atomic number.
 */
class periodentafel {
  public:
    element *start; //!< start of element list
    element *end;   //!< end of element list
    char header1[MAXSTRINGSIZE]; //!< store first header line
    char header2[MAXSTRINGSIZE]; //!< store second header line

  periodentafel();
  ~periodentafel();

  bool AddElement(element *pointer);
  bool RemoveElement(element *pointer);
  bool CleanupPeriodtable();
  element * FindElement(int Z);
  element * FindElement(const char *shorthand) const;
  element * AskElement();
  bool Output(ofstream *output) const;
  bool Checkout(ofstream *output, const int *checkliste) const;
  bool LoadPeriodentafel(const char *path);
  bool StorePeriodentafel(const char *path) const;

  private:
};


#endif /*PERIODENTAFEL_HPP_*/
