/*
 * lists.hpp
 *
 *  Created on: Oct 9, 2009
 *      Author: heber
 */

#ifndef LISTS_HPP_
#define LISTS_HPP_

/******************************** Some templates for list management ***********************************/

/** Adds linking of an item to a list.
 * \param *walker
 * \return true - adding succeeded, false - error in list
 */
template <typename X> void link(X *walker, X *end)
{
  X *vorher = end->previous;
  if (vorher != NULL)
    vorher->next = walker;
  end->previous = walker;
  walker->previous = vorher;
  walker->next = end;
};

/** Removes linking of an item in a list.
 * \param *walker
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void unlink(X *walker)
{
  if (walker->next != NULL)
    walker->next->previous = walker->previous;
  if (walker->previous != NULL)
    walker->previous->next = walker->next;
};

/** Adds new item before an item \a *end in a list.
 * \param *pointer   item to be added
 * \param *end  end of list
 * \return true - addition succeeded, false - unable to add item to list
 */
template <typename X>  bool add(X *pointer, X *end)
{
  if (end != NULL) {
    link(pointer, end);
  } else {
    pointer->previous = NULL;
    pointer->next = NULL;
  }
  return true;
};

/** Finds item in list
 * \param *suche  search criteria
 * \param *start  begin of list
 * \param *end  end of list
 * \return X - if found, NULL - if not found
 */
template <typename X, typename Y> X * find(Y *suche, X *start, X *end)
{
  X *walker = start;
  while (walker->next != end) { // go through list
    walker = walker->next; // step onward beforehand
    if (*walker->sort == *suche) return (walker);
  }
  return NULL;
};

/** Removes an item from the list without check.
 * \param *walker item to be removed
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> void removewithoutcheck(X *walker)
{
  if (walker != NULL) {
    unlink(walker);
    delete(walker);
    walker = NULL;
  }
};

/** Removes an item from the list, checks if exists.
 * Checks beforehand if atom is really within molecule list.
 * \param *pointer   item to be removed
 * \param *start  begin of list
 * \param *end  end of list
 * \return true - removing succeeded, false - given item not found in list
 */
template <typename X> bool remove(X *pointer, X *start, X *end)
{
  X *walker = find (pointer->sort, start, end);
/*  while (walker->next != pointer) { // search through list
    walker = walker->next;
    if (walker == end) return false;  // item not found in list
  }*/
  // atom found, now unlink
  if (walker != NULL)
    removewithoutcheck(walker);
  else
    return false;
  return true;
};

/** Cleans the whole list.
 * \param *start begin of list
 * \param *end end of list
 * \return true - list was cleaned successfully, false - error in list structure
 */
template <typename X> bool cleanup(X *start, X *end)
{
  X *pointer = start->next;
  X *walker;
  while (pointer != end) { // go through list
    walker = pointer; // mark current
    pointer = pointer->next; // step onward beforehand
    // remove walker
    unlink(walker);
    delete(walker);
    walker = NULL;
  }
  return true;
};

/** Returns the first marker in a chain list.
 * \param *me one arbitrary item in chain list
 * \return poiner to first marker
 */
template <typename X> X *GetFirst(X *me)
{
  X *Binder = me;
  while(Binder->previous != NULL)
    Binder = Binder->previous;
  return Binder;
};

/** Returns the last marker in a chain list.
 * \param *me one arbitrary item in chain list
 * \return poiner to last marker
 */
template <typename X> X *GetLast(X *me)
{
  X *Binder = me;
  while(Binder->next != NULL)
    Binder = Binder->next;
  return Binder;
};

#endif /* LISTS_HPP_ */
