/*
 * leastsquaremin.cpp
 *
 *  Created on: Aug 18, 2009
 *      Author: heber
 */

#include <iostream>

#include "leastsquaremin.hpp"
#include "vector.hpp"

/** Determines sum of squared distances of \a X to all \a **vectors.
 * \param *x reference vector
 * \param *params
 * \return sum of square distances
 */
double LSQ (const gsl_vector * x, void * params)
{
  double sum = 0.;
  struct LSQ_params *par = (struct LSQ_params *)params;
  Vector **vectors = par->vectors;
  int num = par->num;

  for (int i=num;i--;) {
    for(int j=NDIM;j--;)
      sum += (gsl_vector_get(x,j) - (vectors[i])->x[j])*(gsl_vector_get(x,j) - (vectors[i])->x[j]);
  }

  return sum;
};

