/** \file graph.cpp
 * 
 * Function definitions for the class graph.
 * 
 */

#ifndef GRAPH_HPP_
#define GRAPH_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <deque>
#include <map>
#include <set>

/****************************************** forward declarations *****************************/

class atom;
class bond;
class config;
class molecule;

class Graph;
class SubGraph;
class Node;
class Edge;

/********************************************** definitions *********************************/

#define NodeMap pair < int, class Node* >
#define EdgeMap multimap < class Node*, class Edge* >

#define KeyStack deque<int>
#define KeySet set<int>
#define NumberValuePair pair<int, double>
#define Graph map <KeySet, NumberValuePair, KeyCompare >
#define GraphPair pair <KeySet, NumberValuePair >
#define KeySetTestPair pair<KeySet::iterator, bool>
#define GraphTestPair pair<Graph::iterator, bool>


/******************************** Some small functions and/or structures **********************************/

struct KeyCompare
{
  bool operator() (const KeySet SubgraphA, const KeySet SubgraphB) const;
};

//bool operator < (KeySet SubgraphA, KeySet SubgraphB);   //note: this declaration is important, otherwise normal < is used (producing wrong order)
void InsertFragmentIntoGraph(ofstream *out, struct UniqueFragments *Fragment); // Insert a KeySet into a Graph
void InsertGraphIntoGraph(ofstream *out, Graph &graph1, Graph &graph2, int *counter);  // Insert all KeySet's in a Graph into another Graph

/** Structure containing all values in power set combination generation.
 */
struct UniqueFragments {
  config *configuration;
  atom *Root;
  Graph *Leaflet;
  KeySet *FragmentSet;
  int ANOVAOrder;
  int FragmentCounter;
  int CurrentIndex;
  double TEFactor;
  int *ShortestPathList;
  bool **UsedList;
  bond **BondsPerSPList;
  int *BondsPerSPCount;
};

/********************************************** declarations *******************************/

///** Graph class containing the graphs behind molecules.
// */
//class Graph
//{
//	NodeMap ListOfNodes;		//!< tree-list of all nodes in this graph
//	EdgeMap ListOfEdges;		//!< tree-multi-list of all nodes, referenced to node id
//};
//
///** Class describing subgraphs of the Class \a Graph.
// * SubGraph has its own node and edge lists, however also a pointer to its father graph
// * and hence access to its list as well.
// */
//class SubGraph : class Graph
//{
//	class Graph *FatherGraph;		//!< Graph whose subgraph we are
//};
//
///** Class containing the nodes of a graph.
// */
//class Node
//{
//	int	id;				//!< individual id of the node
//	char *Name;		//!< Name of the node for pretty printing
//};
//
///** Class containing egdes in a Graph strructure.
// */
//class Edge
//{
//	class Node *leftnode;		//!< pointer to first node
//	class Node *atomnode;		//!< pointer to second node
//};



#endif /*GRAPH_HPP_*/
