/*
 * bond.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef BOND_HPP_
#define BOND_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/****************************************** forward declarations *****************************/

class atom;

/********************************************** declarations *******************************/

/** Bonds between atoms.
 * Class incorporates bonds between atoms in a molecule,
 * used to derive tge fragments in many-body bond order
 * calculations.
 */
class bond {
  public:
    atom *leftatom;    //!< first bond partner
    atom *rightatom;  //!< second bond partner
    bond *previous; //!< previous atom in molecule list
    bond *next;     //!< next atom in molecule list
    int HydrogenBond;  //!< Number of hydrogen atoms in the bond
    int BondDegree;    //!< single, double, triple, ... bond
    int nr;           //!< unique number in a molecule, updated by molecule::CreateAdjacencyList()
    bool Cyclic;      //!< flag whether bond is part of a cycle or not, given in DepthFirstSearchAnalysis()
    enum EdgeType Type;//!< whether this is a tree or back edge

  atom * GetOtherAtom(atom *Atom) const;
  bond * GetFirstBond();
  bond * GetLastBond();

  bool MarkUsed(enum Shading color);
  enum Shading IsUsed();
  void ResetUsed();
  bool Contains(const atom *ptr);
  bool Contains(const int nr);

  bond();
  bond(atom *left, atom *right);
  bond(atom *left, atom *right, int degree);
  bond(atom *left, atom *right, int degree, int number);
  ~bond();

  private:
    enum Shading Used;        //!< marker in depth-first search, DepthFirstSearchAnalysis()
};

ostream & operator << (ostream &ost, const bond &b);

#endif /* BOND_HPP_ */
