/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ConnectedSubgraph.cpp
 *
 *  Created on: Feb 16, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "ConnectedSubgraph.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "molecule.hpp"
#include "World.hpp"

ConnectedSubgraph::ConnectedSubgraph()
{}

ConnectedSubgraph::~ConnectedSubgraph()
{}

molecule * ConnectedSubgraph::getMolecule() const
{
  molecule *mol = World::getInstance().createMolecule();
  mol->ActiveFlag = true;

  ASSERT(!empty(),
      "ConnectedSubgraph::getMolecule() - we contain no atoms.");
  for (AtomList::const_iterator iter = begin();
      iter != end();
      ++iter) {
#ifndef NDEBUG
    bool status =
#endif
        mol->AddAtom(*iter);
    ASSERT(status,
        "ConnectedSubgraph::getMolecule() - could not add "
        +toString(*this)+" to molecule "+toString(mol)+".");
  }

  return mol;
}

std::ostream & operator<<(std::ostream &ost, const ConnectedSubgraph &graph)
{
  for (ConnectedSubgraph::const_iterator iter = graph.begin();
      iter != graph.end();
      ++iter) {
    if (iter != graph.begin())
      ost << ", ";
    ost << (*iter)->getName();
  }
  return ost;
}
