/*
 * DiscreteParameter_impl.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef DISCRETEPARAMETER_IMPL_HPP_
#define DISCRETEPARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DiscreteParameter.hpp"

#include <vector>

/** Constructor for class DiscreteParameter.
 *
 */
template<typename T>
DiscreteParameter<T>::DiscreteParameter(const std::string &_name) :
  Parameter(_name)
{};

/** Constructor for class DiscreteParameter.
 *
 * @param _name name of this parameter
 * @param _ValidValues valid values for this DiscreteValue
 */
template<typename T>
DiscreteParameter<T>::DiscreteParameter(const std::string &_name, const std::vector<T> &_ValidValues) :
  Parameter(_name),
  DiscreteValue<T>(_ValidValues)
{};

/** Constructor for class DiscreteParameter.
 *
 * @param _name name of this parameter
 * @param _ValidValues valid values for this DiscreteValue
 * @param _value initial value to set
 */
template<typename T>
DiscreteParameter<T>::DiscreteParameter(const std::string &_name, const std::vector<T> &_ValidValues, const T &_value) :
  Parameter(_name),
  DiscreteValue<T>(_ValidValues)
{
  setValue(_value);
};

/** Destructor for class DiscreteParameter.
 *
 */
template<typename T>
DiscreteParameter<T>::~DiscreteParameter()
{};

/** Compares this discrete value against another \a _instance.
 *
 * @param _instance other value to compare to
 * @return true - if contained DiscreteValue and name are the same, false - else
 */
template <class T>
bool DiscreteParameter<T>::operator==(const DiscreteParameter<T> &_instance) const
{
  bool status = true;
  status = status &&
      (*dynamic_cast<const DiscreteValue<T> *>(this) == dynamic_cast<const DiscreteValue<T> &>(_instance));
  status = status && (Parameter::getName() == _instance.Parameter::getName());
  return status;
}

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
Parameter* DiscreteParameter<T>::clone() const
{
  DiscreteParameter<T> *instance = new DiscreteParameter<T>(Parameter::getName(), DiscreteValue<T>::getValidValues());
  instance->setValue(DiscreteValue<T>::getValue());
  return instance;
}


#endif /* DISCRETEPARAMETER_IMPL_HPP_ */
