/*
 * ContinuousParameter.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef CONTINUOUSPARAMETER_HPP_
#define CONTINUOUSPARAMETER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "ContinuousValue.hpp"
#include "Parameter.hpp"

/** This class encapsulates a clonable, continuous value.
 *
 */
template <typename T>
class ContinuousParameter : public Parameter, public ContinuousValue<T>
{
public:
  ContinuousParameter(const std::string &_name);
  ContinuousParameter(const std::string &_name, const T &_value);
  ContinuousParameter(const std::string &_name, const range<T> &_ValidRange);
  ContinuousParameter(const std::string &_name, const range<T> &_ValidRange, const T &_value);
  virtual ~ContinuousParameter();

  // comparator
  bool operator==(const ContinuousParameter<T> &_instance) const;
  bool operator!=(const ContinuousParameter<T> &_instance) const
      { return !((*this)==(_instance)); }

  Parameter* clone() const;

private:
  ContinuousParameter();
};

#include "ContinuousParameter_impl.hpp"

#endif /* CONTINUOUSPARAMETER_HPP_ */
