/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SetParserParametersAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/MpqcParser.hpp"
#include "Parser/MpqcParser_Parameters.hpp"

#include <algorithm>
#include <iostream>
#include <string>

#include "SetParserParametersAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetParserParametersAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr ParserSetParserParametersAction::performCall() {
  // get parser
  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(params.parsername.get());
  FormatParser_Parameters *parameters = FormatParserStorage::getInstance().get(type).parameters;
  ASSERT(parameters != NULL,
      "ParserSetParserParametersAction::performCall() - parameters of parser is NULL.");

  // obtain undo state
  std::stringstream oldparamstream;
  oldparamstream << *parameters;
  LOG(1, "Old parser parameters: '" << *parameters << "'");

  // obtain information
  std::stringstream newparamstream;
  const std::vector< KeyValuePair > keyvalues = params.newparams.get();
  std::for_each(keyvalues.begin(), keyvalues.end(), newparamstream << boost::lambda::_1 << ";");
  newparamstream >> *parameters;
  LOG(1, "New parser parameters: '" << *parameters << "'");

  return ActionState::ptr(new ParserSetParserParametersState(oldparamstream.str(), params));
}

ActionState::ptr ParserSetParserParametersAction::performUndo(ActionState::ptr _state) {
  ParserSetParserParametersState *state = assert_cast<ParserSetParserParametersState*>(_state.get());

  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(state->params.parsername.get());
  FormatParser_Parameters *parser = FormatParserStorage::getInstance().get(type).parameters;
  std::stringstream oldparamstream(state->oldparams);
  oldparamstream >> *parser;

  return ActionState::ptr(_state);
}

ActionState::ptr ParserSetParserParametersAction::performRedo(ActionState::ptr _state){
  ParserSetParserParametersState *state = assert_cast<ParserSetParserParametersState*>(_state.get());

  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(state->params.parsername.get());
  FormatParser_Parameters *parser = FormatParserStorage::getInstance().get(type).parameters;
  std::stringstream newparamstream;
  const std::vector< KeyValuePair > keyvalues = state->params.newparams.get();
  std::for_each(keyvalues.begin(), keyvalues.end(), newparamstream << boost::lambda::_1 << ";");
  newparamstream >> *parser;

  return ActionState::ptr(_state);
}

bool ParserSetParserParametersAction::canUndo() {
  return true;
}

bool ParserSetParserParametersAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
