/*
 * RemoveFromPoolOperation.hpp
 *
 *  Created on: Mar 01, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_
#define FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Operations/AsyncOperation.hpp"
#include "WorkerAddress.hpp"

class RemoveFromPoolOperation : public AsyncOperation  {
public:
  /// Constructor for class RemoveFromPoolOperation.
  RemoveFromPoolOperation(Connection &_connection, const WorkerAddress &_address,
      const boost::function<void ()> &_callback_on_success = NoOpCallback,
      const boost::function<void ()> &_callback_on_failure = NoOpCallback) :
    AsyncOperation(std::string("shutdownworker"),_connection, _callback_on_success, _callback_on_failure),
    address(_address)
  {}
  /// Destructor for class RemoveFromPoolOperation
  ~RemoveFromPoolOperation() {}

public:
  // virtual function pointer to the connection handler
  void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when address has been sent and we ask for removal
  void handle_SendChoice(const boost::system::error_code& e);

  /// Callback function when receiving flag indication succesful removal
  void handle_ReceiveFlag(const boost::system::error_code& e);

  /// Callback function when op is finished.
  void handle_FinishOperation(const boost::system::error_code& e);

private:
  //!> address to enroll with
  WorkerAddress address;

  //!> flag indication successful removal from server
  bool RemovalFlag;
};

#endif /* FRAGMENTCONTROLLER_REMOVEFROMPOOLOPERATION_HPP_ */
