/*
 * MatrixUnitTest.hpp
 *
 *  Created on: Jul 7, 2010
 *      Author: crueger
 */

#ifndef MATRIXUNITTEST_HPP_
#define MATRIXUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class RealSpaceMatrix;

class MatrixUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( MatrixUnittest) ;
  CPPUNIT_TEST ( AccessTest );
  CPPUNIT_TEST ( VectorTest );
  CPPUNIT_TEST ( OperationTest );
  CPPUNIT_TEST ( TransposeTest );
  CPPUNIT_TEST ( RotationTest );
  CPPUNIT_TEST ( InvertTest );
  CPPUNIT_TEST ( DeterminantTest );
  CPPUNIT_TEST ( VecMultTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void AccessTest();
  void VectorTest();
  void OperationTest();
  void TransposeTest();
  void RotationTest();
  void InvertTest();
  void DeterminantTest();
  void VecMultTest();

  RealSpaceMatrix *zero;
  RealSpaceMatrix *one;
  RealSpaceMatrix *full;
  RealSpaceMatrix *diagonal;
  RealSpaceMatrix *perm1;
  RealSpaceMatrix *perm2;
  RealSpaceMatrix *perm3;
  RealSpaceMatrix *perm4;
  RealSpaceMatrix *perm5;
};

#endif /* MATRIXUNITTEST_HPP_ */
