/*
 * MatrixContentUnitTest.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef MATRIXCONTENTUNITTEST_HPP_
#define MATRIXCONTENTUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class MatrixContent;

/********************************************** Test classes **************************************/

class MatrixContentTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MatrixContentTest) ;
    CPPUNIT_TEST (AccessTest );
    CPPUNIT_TEST (InitializationTest );
    CPPUNIT_TEST (CopyTest );
    CPPUNIT_TEST (ExchangeTest );
    CPPUNIT_TEST (PropertiesTest );
    CPPUNIT_TEST (ReadWriteTest );
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp();
    void tearDown();

    void AccessTest();
    void InitializationTest();
    void CopyTest();
    void ExchangeTest();
    void PropertiesTest();
    void ReadWriteTest();

private:
    MatrixContent *m;
};


#endif /* MATRIXCONTENTUNITTEST_HPP_ */
