/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Space.cpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <limits>

#include "defs.hpp"
#include "Space.hpp"
#include "Vector.hpp"

Space::Space()
{}

Space::~Space()
{}

bool Space::hasZero() const{
  return isContained(zeroVec);
}

Vector Space::getVectorToPoint(const Vector &origin) const{
  Vector support = getClosestPoint(origin);
  return support-origin;
}

bool Space::isContained(const Vector &point) const{
  return (distance(point)) <= LINALG_MYEPSILON();
}
