/*
 * LinearSystemOfEquations.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef LINEARSYSTEMSOFEQUATIONS_HPP
#define LINEARSYSTEMSOFEQUATIONS_HPP

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_linalg.h>

/****************************************** forward declarations *****************************/

class Vector;
class MatrixContent;
class VectorContent;

/********************************************** declarations *******************************/

/** Solver class for a linear system of equations in the form \f$A \cdot x = b\F$.
 *
 */
class LinearSystemOfEquations {
public:
  LinearSystemOfEquations(int n, int m);
  ~LinearSystemOfEquations();

  // setting
  void Setb(Vector *x);
  void Setb(double *x);
  void SetA(double *x);
  bool SetSymmetric(bool symmetric);

  // solving
  bool GetSolutionAsArray(double *&array);
  bool GetSolutionAsVector(Vector &v);

  VectorContent *b;
  VectorContent *x;
  MatrixContent *A;

private:
  bool Solve();

  int rows;
  int columns;

  bool IsSymmetric;
};

#endif /* LINEARSYSTEMSOFEQUATIONS_HPP */
