/*
 * Line.hpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#ifndef LINE_HPP_
#define LINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "Space.hpp"

#include <iosfwd>
#include <memory>
#include <vector>

class Vector;
class Plane;
class LinePoint;

class Line : public Space
{
  friend bool operator==(const Line&,const Line&);
  friend class LinePoint;
public:
  Line(const Vector &_origin, const Vector &_direction);
  Line(const Line& _src);
  virtual ~Line();

  Line &operator=(const Line& rhs);

  virtual double distance(const Vector &point) const;
  virtual Vector getClosestPoint(const Vector &point) const;

  Vector getDirection() const;
  Vector getOrigin() const;

  std::vector<Vector> getPointsOnLine() const;

  Vector getIntersection(const Line& otherLine) const;

  Vector rotateVector(const Vector &rhs, double alpha) const;
  Line rotateLine(const Line &rhs, double alpha) const;
  Plane rotatePlane(const Plane &rhs, double alpha) const;

  Plane getOrthogonalPlane(const Vector &origin) const;

  std::vector<Vector> getSphereIntersections() const;

  LinePoint getLinePoint(const Vector&) const;
  LinePoint posEndpoint() const;
  LinePoint negEndpoint() const;



private:
  std::auto_ptr<Vector> origin;
  std::auto_ptr<Vector> direction;
};

bool operator==(const Line&,const Line&);

std::ostream & operator << (std::ostream& ost, const Line &m);

/**
 * Named constructor to make a line through two points
 */
Line makeLineThrough(const Vector &x1, const Vector &x2);

/**
 * Class for representing points on a line
 * These objects allow comparison of points on the same line as well as specifying the
 * infinite "endpoints" of a line.
 */
class LinePoint{
  friend class Line;
  friend bool operator==(const LinePoint&, const LinePoint&);
  friend bool operator<(const LinePoint&, const LinePoint&);
public:
  LinePoint(const LinePoint&);
  LinePoint& operator=(const LinePoint&);
  Vector getPoint() const;
  Line getLine() const;
  bool isInfinite() const;
  bool isPosInfinity() const;
  bool isNegInfinity() const;

private:
  LinePoint(const Line&,double);
  Line line;
  double param;
};

bool operator==(const LinePoint&, const LinePoint&);
bool operator<(const LinePoint&, const LinePoint&);

inline bool operator!= (const LinePoint& x, const LinePoint& y) { return !(x==y); }
inline bool operator>  (const LinePoint& x, const LinePoint& y) { return y<x; }
inline bool operator<= (const LinePoint& x, const LinePoint& y) { return !(y<x); }
inline bool operator>= (const LinePoint& x, const LinePoint& y) { return !(x<y); }


#endif /* LINE_HPP_ */
