/*
 * BoxVector.hpp
 *
 *  Created on: Aug 26, 2010
 *      Author: heber
 */

#ifndef BOXVECTOR_HPP_
#define BOXVECTOR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <iosfwd>

#include "Vector.hpp"

/** A BoxVector is simply a Vector that adheres to the boundary conditions of
 * the box. Is currently only needed in Dialog::query<> to distinguish between
 * BoxVector and Vector.
 */
class BoxVector : public Vector
{
public:
  BoxVector();
  ~BoxVector();
};

ostream & operator << (ostream& ost, const BoxVector &m);
const BoxVector& operator*=(BoxVector& a, const double m);
BoxVector const operator*(const BoxVector& a, const double m);
BoxVector const operator*(const double m, const BoxVector& a);

#endif /* BOXVECTOR_HPP_ */
