/*
 * TextUIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "UIElements/TextUI/TextUIFactory.hpp"
#include "UIElements/TextUI/TextWindow.hpp"
#include "UIElements/TextUI/TextDialog.hpp"

TextUIFactory::TextUIFactory()
{}

TextUIFactory::~TextUIFactory()
{}


Dialog* TextUIFactory::makeDialog() {
  return new TextDialog();
}

MainWindow* TextUIFactory::makeMainWindow() {
  return new TextWindow();
}

TextUIFactory::description::description() :
    UIFactory::factoryDescription("Text")
{}

TextUIFactory::description::~description()
{}

UIFactory* TextUIFactory::description::makeFactory(){
  return new TextUIFactory();
}

