/*
 * PairCorrelationAction.hpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#ifndef PAIRCORRELATIONACTION_HPP_
#define PAIRCORRELATIONACTION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Actions/Action.hpp"
#include <string>
#include <vector>

class element;

void AnalysisPairCorrelation(std::vector< element *> &elements, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);

class AnalysisPairCorrelationAction : public Action {
  friend void AnalysisPairCorrelation(std::vector< element *> &elements, double BinStart, double BinWidth, double BinEnd, std::string &outputname, std::string &binoutputname, bool periodic);
public:
  AnalysisPairCorrelationAction();
  virtual ~AnalysisPairCorrelationAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog*);
private:
   virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* PAIRCORRELATIONACTION_HPP_ */
