/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DipoleAngularCorrelationAction.cpp
 *
 *  Created on: Feb 11, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Analysis/analysis_correlation.hpp"
#include "Tesselation/boundary.hpp"
#include "linkedcell.hpp"
#include "CodePatterns/Log.hpp"
#include "Element/element.hpp"
#include "molecule.hpp"
#include "Element/periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"
#include "WorldTime.hpp"

#include <iostream>
#include <map>
#include <string>

#include "Actions/AnalysisAction/DipoleAngularCorrelationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "DipoleAngularCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisDipoleAngularCorrelationAction::performCall() {
  //int ranges[3] = {1, 1, 1};
  string type;

  // obtain information
  getParametersfromValueStorage();

  // open files
  ofstream output;
  ofstream binoutput;
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());

  // get selected atoms
  std::vector<atom*> atoms = World::getInstance().getSelectedAtoms();
  LOG(0, "STATUS: There are " << atoms.size() << " selected atoms.");
  ASSERT(!params.periodic, "AnalysisDipoleAngularCorrelationAction() - periodic case not implemented.");

  // calculate dipoles relative to zero orientation and put into maps
  DipoleAngularCorrelationMap *correlationmap = NULL;
  std::map<atomId_t, Vector> ZeroVector;
  correlationmap = DipoleAngularCorrelation(atoms, ZeroVector);
  OutputCorrelationMap<DipoleAngularCorrelationMap>(&output, correlationmap, OutputDipoleAngularCorrelation_Header, OutputDipoleAngularCorrelation_Value);

  // bin maps
  BinPairMap *binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelationMap<BinPairMap> ( &binoutput, binmap, OutputCorrelation_Header, OutputCorrelation_Value );

  // free maps
  delete(binmap);
  delete(correlationmap);

  // close files
  output.close();
  binoutput.close();

  // exit
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisDipoleAngularCorrelationAction::canUndo() {
  return true;
}

bool AnalysisDipoleAngularCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
