/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ExtractorsUnitTest.cpp
 *
 *  Created on: Oct 16, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "ExtractorsUnitTest.hpp"

#include <boost/assign.hpp>

#include "CodePatterns/Assert.hpp"

#include "FunctionApproximation/Extractors.hpp"
#include "Potentials/helpers.hpp"

using namespace boost::assign;

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ExtractorsTest );


void ExtractorsTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

}


void ExtractorsTest::tearDown()
{
}

/** UnitTest for gatherAllSymmetricDistances()
 */
void ExtractorsTest::gatherAllSymmetricDistancesTest()
{
  // create positions
  Fragment::positions_t positions;
  Fragment::position_t pos(3, 0.);
  for (double i = 0; i < 5; i+=1.) {
    pos[0] = i;
    positions.push_back(pos);
  }

  // create charges
  Fragment::atomicnumbers_t atomicnumbers;
  atomicnumbers += 6, 6, 1, 1, 1;

  // create distances
  FunctionModel::arguments_t args =
      Extractors::gatherAllSymmetricDistances(positions, atomicnumbers, 0);
  CPPUNIT_ASSERT_EQUAL( (size_t)(5*4/2), args.size() );

  // check created args
  for (size_t i=0; i< 5*4; ++i)
    CPPUNIT_ASSERT( (args[i].distance >= 0) && (args[i].distance <= 4));
}
