/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinearInterpolationofTrajectoriesAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/LinearInterpolationofTrajectoriesAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "defs.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


/****** MoleculeLinearInterpolationofTrajectoriesAction *****/

// memento to remember the state when undoing

//class MoleculeLinearInterpolationofTrajectoriesState : public ActionState {
//public:
//  MoleculeLinearInterpolationofTrajectoriesState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeLinearInterpolationofTrajectoriesAction::NAME[] = "linear-interpolate";

MoleculeLinearInterpolationofTrajectoriesAction::MoleculeLinearInterpolationofTrajectoriesAction() :
  Action(NAME)
{}

MoleculeLinearInterpolationofTrajectoriesAction::~MoleculeLinearInterpolationofTrajectoriesAction()
{}

void MoleculeLinearInterpolationofTrajectories(std::string &filename, int start, int end, bool IdMapping) {
  ValueStorage::getInstance().setCurrentValue(MoleculeLinearInterpolationofTrajectoriesAction::NAME, filename);
  ValueStorage::getInstance().setCurrentValue("start-step", start);
  ValueStorage::getInstance().setCurrentValue("end-step", end);
  ValueStorage::getInstance().setCurrentValue("id-mapping", IdMapping);
  ActionRegistry::getInstance().getActionByName(MoleculeLinearInterpolationofTrajectoriesAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeLinearInterpolationofTrajectoriesAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));
  dialog->queryInt("start-step", ValueStorage::getInstance().getDescription("start-step"));
  dialog->queryInt("end-step", ValueStorage::getInstance().getDescription("end-step"));
  dialog->queryBoolean("id-mapping", ValueStorage::getInstance().getDescription("id-mapping"));

  return dialog;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performCall() {
  string filename;
  molecule *mol = NULL;
  int start = -1;
  int end = -1;
  bool IdMapping = true;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);
  ValueStorage::getInstance().queryCurrentValue("start-step", start);
  ValueStorage::getInstance().queryCurrentValue("end-step", end);
  ValueStorage::getInstance().queryCurrentValue("id-mapping", IdMapping);

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Linear interpolation between configuration " << start << " and " << end << "." << endl);
    if (IdMapping)
      DoLog(1) && (Log() << Verbose(1) << "Using Identity for the permutation map." << endl);
    if (!mol->LinearInterpolationBetweenConfiguration(start, end, filename, *(World::getInstance().getConfig()), IdMapping))
      DoLog(2) && (Log() << Verbose(2) << "Could not store " << filename << " files." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "Steps created and " << filename << " files stored." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performUndo(Action::state_ptr _state) {
//  MoleculeLinearInterpolationofTrajectoriesState *state = assert_cast<MoleculeLinearInterpolationofTrajectoriesState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeLinearInterpolationofTrajectoriesAction::canUndo() {
  return false;
}

bool MoleculeLinearInterpolationofTrajectoriesAction::shouldUndo() {
  return false;
}

const string MoleculeLinearInterpolationofTrajectoriesAction::getName() {
  return NAME;
}
