/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BondFileAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/BondFileAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


/****** MoleculeBondFileAction *****/

// memento to remember the state when undoing

//class MoleculeBondFileState : public ActionState {
//public:
//  MoleculeBondFileState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeBondFileAction::NAME[] = "bond-file";

MoleculeBondFileAction::MoleculeBondFileAction() :
  Action(NAME)
{}

MoleculeBondFileAction::~MoleculeBondFileAction()
{}

void MoleculeBondFile(std::string &bondfile) {
  ValueStorage::getInstance().setCurrentValue(MoleculeBondFileAction::NAME, bondfile);
  ActionRegistry::getInstance().getActionByName(MoleculeBondFileAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeBondFileAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeBondFileAction::performCall() {
  string filename;
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, filename);

  if(World::getInstance().countSelectedMolecules() == 1) {
    mol = World::getInstance().beginMoleculeSelection()->second;
    DoLog(0) && (Log() << Verbose(0) << "Parsing bonds from " << filename << "." << endl);
    ifstream input(filename.c_str());
    mol->CreateAdjacencyListFromDbondFile(&input);
    input.close();
    return Action::success;
  } else
    return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performUndo(Action::state_ptr _state) {
//  MoleculeBondFileState *state = assert_cast<MoleculeBondFileState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeBondFileAction::canUndo() {
  return false;
}

bool MoleculeBondFileAction::shouldUndo() {
  return false;
}

const string MoleculeBondFileAction::getName() {
  return NAME;
}
