/*
 * ParticleRegistry.hpp
 *
 *  Created on: May 13, 2013
 *      Author: heber
 */

#ifndef PARTICLEREGISTRY_HPP_
#define PARTICLEREGISTRY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Registry.hpp"
#include "CodePatterns/Singleton.hpp"

#include "Potentials/Particles/Particle.hpp"

/** Particle Registry.
 *
 * The Potential registry is a storage for any Particle instance to
 * be retrieved by name. It is a singleton and can be called from anywhere.
 *
 */
class ParticleRegistry : public Singleton<ParticleRegistry>, public Registry<Particle>
{
  friend class Singleton<ParticleRegistry>;
  //friend class Registry<class Particle>;

public:

private:
  ParticleRegistry() {}
  ~ParticleRegistry()
  {
    // don't forget to clean up, no automatism with Registry<T>
    cleanup();
  }
};

#endif /* PARTICLEREGISTRY_HPP_ */
