/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * UndoTillMarkAction.cpp
 *
 *  Created on: Aug 13, 2025
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "ActionQueue.hpp"

#include <iostream>

#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;

#include "Actions/CommandAction/UndoTillMarkAction.hpp"

// and construct the stuff
#include "UndoTillMarkAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
ActionState::ptr CommandUndoTillMarkAction::performCall(){
  // std::cout << "Undo" << std::endl;
  ActionQueue::getInstance().undoTillMark();
}

ActionState::ptr CommandUndoTillMarkAction::performUndo(ActionState::ptr){
  ASSERT(0,"Cannot undo an undo (should use redo for this");
  return Action::success;
}

ActionState::ptr CommandUndoTillMarkAction::performRedo(ActionState::ptr){
  ASSERT(0,"Cannot redo an undo");
  return Action::success;
}

bool CommandUndoTillMarkAction::canUndo(){
  return false;
}

bool CommandUndoTillMarkAction::shouldUndo(){
  return false;
}
/** =========== end of function ====================== */
