/*
 * TesselationHelpers.hpp
 *
 *  Auxiliary functions for the tesselation.
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef TESSELATIONHELPERS_HPP_
#define TESSELATIONHELPERS_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_linalg.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_multimin.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_vector.h>

#include <iostream>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class LinkedCell;
class TesselPoint;
class PointCloud;
class Tesselation;
class Vector;

/********************************************** definitions *********************************/

#define HULLEPSILON 1e-10

/********************************************** declarations *******************************/

double DetGet(gsl_matrix * const A, const int inPlace);
void GetSphere(Vector * const Center, const Vector &a, const Vector &b, const Vector &c, const double RADIUS);
void GetCenterOfSphere(Vector* const Center, const Vector &a, const Vector &b, const Vector &c, Vector * const NewUmkreismittelpunkt, const Vector* const Direction, const Vector* const AlternativeDirection, const double HalfplaneIndicator, const double AlternativeIndicator, const double alpha, const double beta, const double gamma, const double RADIUS, const double Umkreisradius);
void GetCenterofCircumcircle(Vector * const Center, const Vector &a, const Vector &b, const Vector &c);
double GetPathLengthonCircumCircle(const Vector &CircleCenter, const Vector &CirclePlaneNormal, const double CircleRadius, const Vector &NewSphereCenter, const Vector &OldSphereCenter, const Vector &NormalVector, const Vector &SearchDirection);
double MinIntersectDistance(const gsl_vector * x, void *params);
bool existsIntersection(const Vector &point1, const Vector &point2, const Vector &point3, const Vector &point4);
double CalculateVolumeofGeneralTetraeder(const Vector &a, const Vector &b, const Vector &c, const Vector &d);
double GetAngle(const Vector &point, const Vector &reference, const Vector &OrthogonalVector);

bool CheckLineCriteriaForDegeneratedTriangle(const BoundaryPointSet * const nodes[3]);
bool SortCandidates(const CandidateForTesselation* candidate1, const CandidateForTesselation *candidate2);
TesselPoint* FindClosestTesselPoint(const Vector* Point, TesselPoint *&SecondPoint, const LinkedCell* const LC);
TesselPoint* FindSecondClosestTesselPoint(const Vector*, const LinkedCell* const LC);
Vector * GetClosestPointBetweenLine(const BoundaryLineSet * const Base, const BoundaryLineSet * const OtherBase);

void WriteTecplotFile(ofstream * const tecplot, const Tesselation * const TesselStruct, const PointCloud * const cloud, const int N);
void WriteRaster3dFile(ofstream * const rasterfile, const Tesselation * const Tess, const PointCloud * const cloud);
void IncludeSphereinRaster3D(ofstream * const rasterfile, const Tesselation *Tess, const PointCloud *cloud);
void WriteVrmlFile(ofstream * const vrmlfile, const Tesselation * const Tess, const PointCloud * const cloud);
void CalculateConcavityPerBoundaryPoint(const Tesselation * const TesselStruct);
double DistanceToTrianglePlane(const Vector *x, const BoundaryTriangleSet * const triangle);

bool CheckListOfBaselines(const Tesselation * const TesselStruct);

int CountTrianglePairContainingPolygon(const BoundaryPolygonSet * const P, const TriangleSet * const T);
bool ArePolygonsEdgeConnected(const BoundaryPolygonSet * const P1, const BoundaryPolygonSet * const P2);
void CombinePolygons(BoundaryPolygonSet * const P1, BoundaryPolygonSet * &P2);


#endif /* TESSELATIONHELPERS_HPP_ */
