/*
 * gslvector.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef GSLVECTOR_HPP_
#define GSLVECTOR_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_vector.h>

/****************************************** forward declarations *****************************/

class GSLVector;

/********************************************** declarations *******************************/

class GSLVector {
  friend class LinearSystemOfEquations;

public:
  GSLVector(size_t m);
  GSLVector(const GSLVector * const src);
  ~GSLVector();

  // Accessing
  void SetFromDoubleArray(double *x);
  double Get(size_t m);
  void Set(size_t m, double x);
  double *Pointer(size_t m);
  const double *const_Pointer(size_t m);

  // Initializing
  void SetAll(double x);
  void SetZero();
  int SetBasis(size_t m);

  // Exchanging elements
  int SwapElements(size_t i, size_t j);
  int Reverse();

private:
  gsl_vector *vector;

  size_t dimension;
};



#endif /* GSLVECTOR_HPP_ */
