/*
 * gslmatrix.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef GSLMATRIX_HPP_
#define GSLMATRIX_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_matrix.h>

/****************************************** forward declarations *****************************/

class GSLMatrix;

/********************************************** declarations *******************************/

class GSLMatrix {
  friend class LinearSystemOfEquations;

public:
  GSLMatrix(size_t m, size_t n);
  GSLMatrix(const GSLMatrix * const src);
  ~GSLMatrix();

  // Accessing
  void SetFromDoubleArray(double * x);
  double Get(size_t m, size_t n);
  void Set(size_t m, size_t n, double x);
  double *Pointer(size_t m, size_t n);
  const double *const_Pointer(size_t m, size_t n);

  // Initializing
  void SetAll(double x);
  void SetZero();
  void SetIdentity();

  // Exchanging elements
  bool SwapRows(size_t i, size_t j);
  bool SwapColumns(size_t i, size_t j);
  bool SwapRowColumn(size_t i, size_t j);
  bool Transpose();
  bool IsNull();
  bool IsPositive();
  bool IsNegative();
  bool IsNonNegative();
  bool IsPositiveDefinite();
  double Determinant();

  GSLMatrix& operator=(const GSLMatrix& rhs);

private:
  gsl_matrix *matrix;

  size_t rows;
  size_t columns;
};


#endif /* GSLMATRIX_HPP_ */
