/*
 * AnalysisCorrelationToSurfaceUnitTest.hpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

#ifndef ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_
#define ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class element;
class molecule;
class LinkedCell;
class periodentafel;
class Tesselation;

/********************************************** Test classes **************************************/

class AnalysisCorrelationToSurfaceUnitTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisCorrelationToSurfaceUnitTest ) ;
    CPPUNIT_TEST ( CorrelationToSurfaceTest );
    CPPUNIT_TEST ( CorrelationToSurfaceHydrogenBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceHydrogenBinRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceCarbonBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceCarbonBinRangeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void CorrelationToSurfaceTest();
      void CorrelationToSurfaceHydrogenBinNoRangeTest();
      void CorrelationToSurfaceHydrogenBinRangeTest();
      void CorrelationToSurfaceCarbonBinNoRangeTest();
      void CorrelationToSurfaceCarbonBinRangeTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      element *carbon;
      periodentafel *tafel;

      CorrelationToSurfaceMap *surfacemap;
      BinPairMap *binmap;
      Tesselation *Surface;
      LinkedCell *LC;
};

#endif /* ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_ */
