/*
 * AtomSelectionDescriptor.cpp
 *
 *  Created on: Jul 16, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor_impl.hpp"

#include "Helpers/helpers.hpp"

AtomSelectionDescriptor_impl::AtomSelectionDescriptor_impl(){}

AtomSelectionDescriptor_impl::~AtomSelectionDescriptor_impl(){}

bool AtomSelectionDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom){
  return getSelectedAtoms().count(atom.first);
}

atom* AtomSelectionDescriptor_impl::find(){
  World::AtomSet &set = getSelectedAtoms();
  World::AtomSet::internal_iterator begin = set.begin_internal();
  return (begin!=set.end_internal())?(begin->second):0;
}

std::vector<atom*> AtomSelectionDescriptor_impl::findAll(){
  std::vector<atom*> res;
  World::AtomSet &set = getSelectedAtoms();
  transform(set.begin_internal(),
           set.end_internal(),
           back_inserter(res),
           _take<atom*,World::AtomSet::value_type>::get);
  return res;
}

World::AtomSet& AtomSelectionDescriptor_impl::getSelectedAtoms(){
  return World::getInstance().selectedAtoms;
}

AtomDescriptor AtomsBySelection(){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomSelectionDescriptor_impl()));
}
