/*
 * FragmentationChargeDensity.hpp
 *
 *  Created on: Aug 31, 2012
 *      Author: heber
 */

#ifndef FRAGMENTATIONCHARGEDENSITY_HPP_
#define FRAGMENTATIONCHARGEDENSITY_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <vector>

#include "JobMarket/types.hpp"

#include "Fragmentation/SetValues/Fragment.hpp"
#include "Fragmentation/Summation/IndexSet.hpp"
#include "Jobs/MPQCData.hpp"
#include "Jobs/MPQCDataMap.hpp"
#include "Jobs/Grid/SamplingGrid.hpp"

class KeySetsContainer;

/** This structure is a container for the summed up charge density per level.
 *
 */
struct FragmentationChargeDensity
{
  /** Sums up sampled charge grids contained in \a fragmentData.
   *
   * @param fragmentData MPQCData resulting from the jobs, each associated to a job
   * @param KeySet KeySets of all (non-hydrogen) atoms
   */
  FragmentationChargeDensity(
      const std::map<JobId_t,MPQCData> &fragmentData,
      const KeySetsContainer& KeySet);

  std::vector<SamplingGrid> getFullSampledGrid();

  const Fragment &getFragment();

  //!> results per level of summed up sampled grid charge
  std::vector<MPQCDataGridMap_t> Result_Grid_fused;
  //!> results per level of summed up fragment positions and charges
  std::vector<MPQCDataFragmentMap_t> Result_Fragment_fused;

  //!> results per IndexSet of summed up sampled grid charge
  std::map<IndexSet::ptr, std::pair<MPQCDataGridMap_t, MPQCDataGridMap_t> > Result_perIndexSet_Grid;
  //!> results per IndexSet of summed up fragment positions and charges
  std::map<IndexSet::ptr, std::pair<MPQCDataFragmentMap_t, MPQCDataFragmentMap_t> > Result_perIndexSet_Fragment;

private:
  /** Helper function to call OrthogonalSummation.
   *
   * \param fragmentData map of calculated jobs
   * \param KeySet container of all keysets
   * \param MatrixNrLookup map with enumerated job ids
   */
  void sumUp(
      const std::map<JobId_t,MPQCData> &fragmentData,
      const KeySetsContainer &KeySet,
      const std::map< JobId_t, size_t > &MatrixNrLookup);

};

#endif /* FRAGMENTATIONCHARGEDENSITY_HPP_ */
