/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ParseFragmentJobsAction.cpp
 *
 *  Created on: Mar 04, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "Fragmentation/Automation/FragmentJobQueue.hpp"

#include <boost/filesystem.hpp>
#include <string>

#include "Actions/FragmentationAction/ParseFragmentJobsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ParseFragmentJobsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationParseFragmentJobsAction::performCall() {
  // check for present jobs
  if (params.jobfiles.get().empty()) {
    ELOG(2, "Given vector of jobfiles is empty!");
    return Action::failure;
  }

  // parse in fragment-jobs if given
  if(!FragmentJobQueue::getInstance().addJobsFromFiles(
      params.jobfiles.get(),
      params.level.get()))
    return Action::failure;
  size_t FragmentCounter = FragmentJobQueue::getInstance().size();
  LOG(1, "STATUS: I parsed " << FragmentCounter << " fragment files.");

  // then parse in KeySets and add on top
  FragmentJobQueue::getInstance().addKeySetsFromFiles(params.path.get(), FragmentCounter, NonHydrogenKeySets);
  FragmentJobQueue::getInstance().addFullKeySetsFromFiles(params.path.get(), FragmentCounter, NonHydrogenKeySets);

  return Action::success;
}

Action::state_ptr FragmentationParseFragmentJobsAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationParseFragmentJobsAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationParseFragmentJobsAction::canUndo() {
  return true;
}

bool FragmentationParseFragmentJobsAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
