/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ShutdownWorkerOperation.cpp
 *
 *  Created on: 11.12.2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "ShutdownWorkerOperation.hpp"

#include <boost/bind.hpp>
#include <iostream>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "CodePatterns/Info.hpp"
#include "ControllerChoices.hpp"
#include "Jobs/SystemCommandJob.hpp"
#include "JobId.hpp"

FragmentJob::ptr ShutdownWorkerOperation::NoJob(new SystemCommandJob(std::string(""), std::string(""), JobId::NoJob));

/** Handle connect operation to shutdown scheduler.
 *
 * \param e error code if something went wrong
 * \param endpoint_iterator endpoint of the connection
 */
void ShutdownWorkerOperation::handle_connect(const boost::system::error_code& e,
    boost::asio::ip::tcp::resolver::iterator endpoint_iterator)
{
  Info info(__FUNCTION__);
  if (!e)
  {
    // The connection::async_write() function will automatically
    // serialize the data structure for us.
    connection_.async_write(NoJob,
      boost::bind(&ShutdownWorkerOperation::handle_FinishOperation, this,
      boost::asio::placeholders::error));
  } else if (endpoint_iterator != boost::asio::ip::tcp::resolver::iterator()) {
    // Try the next endpoint.
    connection_.socket().close();
    boost::asio::ip::tcp::endpoint endpoint = *endpoint_iterator;
    connection_.socket().async_connect(endpoint,
      boost::bind(&ShutdownWorkerOperation::handle_connect, this,
      boost::asio::placeholders::error, ++endpoint_iterator));
  } else {
    // An error occurred. Log it and return. Since we are not starting a new
    // operation the io_service will run out of work to do and the client will
    // exit.
    Exitflag = ErrorFlag;
    ELOG(1, e.message());
  }
}

