/*
 * ShutdownWorkerOperation.hpp
 *
 *  Created on: Mar 04, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SHUTDOWNWORKEROPERATION_HPP_
#define FRAGMENTCONTROLLER_SHUTDOWNWORKEROPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Jobs/FragmentJob.hpp"
#include "Operations/AsyncOperation.hpp"

/** Synchronous operation that gives shutdown command.
 *
 */
class ShutdownWorkerOperation : public AsyncOperation  {
public:
  /// Constructor for class ShutdownWorkerOperation.
  ShutdownWorkerOperation(Connection &_connection) :
    AsyncOperation(std::string("shutdown"),_connection) {}
  /// Destructor for class ShutdownWorkerOperation
  ~ShutdownWorkerOperation() {}

public:
  // virtual function pointer to the connection handler
  void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

private:
  //!> static entity to indicate to clients that the queue is empty.
  static FragmentJob::ptr NoJob;
};

#endif /* FRAGMENTCONTROLLER_SHUTDOWNWORKEROPERATION_HPP_ */
