/*
 * bond.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef BOND_HPP_
#define BOND_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/****************************************** forward declarations *****************************/

class atom;
class ParticleInfo;

/********************************************** declarations *******************************/

/** Bonds between atoms.
 * Class incorporates bonds between atoms in a molecule.
 * Note that we regard bond always as something in a molecule,
 * as it is the glue making up the connected subgrapgh and
 * hence the molecule. Thus, bonds belong globally to the molecule
 * (and are free'd there) and only locally to the atom classs.
 */
class bond {
  public:
    atom *leftatom;    //!< first bond partner
    atom *rightatom;  //!< second bond partner
    bond *previous; //!< previous atom in molecule list
    bond *next;     //!< next atom in molecule list
    int HydrogenBond;  //!< Number of hydrogen atoms in the bond
    int BondDegree;    //!< single, double, triple, ... bond
    int nr;           //!< unique number in a molecule, updated by molecule::CreateAdjacencyList()
    bool Cyclic;      //!< flag whether bond is part of a cycle or not, given in DepthFirstSearchAnalysis()
    enum EdgeType Type;//!< whether this is a tree or back edge

  atom * GetOtherAtom(const ParticleInfo * const Atom) const;

  bool MarkUsed(const enum Shading color);
  enum Shading IsUsed();
  void ResetUsed();
  bool Contains(const ParticleInfo * const ptr);
  bool Contains(const int nr);
  double GetDistance() const;
  double GetDistanceSquared() const;

  bond();
  bond(atom *left, atom *right, const int degree=1, const int number=0);
  ~bond();

  private:
    enum Shading Used;        //!< marker in depth-first search, DepthFirstSearchAnalysis()
};

ostream & operator << (ostream &ost, const bond &b);

#endif /* BOND_HPP_ */
