/*
 * QtMoleculeItem_atomcount.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_ATOMCOUNT_HPP_
#define QTMOLECULEITEM_ATOMCOUNT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "CodePatterns/ObservedValue.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "molecule.hpp"
#include "World.hpp"

class QtMoleculeItemFactory;

/** This class contains the atomcount of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_atomcount : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_atomcount(
      const moleculeId_t _molid,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_molid, channellist_atomcount, QtMoleculeItem::NeedsMove, _emitDirtyState),
        molref(getMolecule()),
        atomcount(
            molref,
            boost::bind(&QtMoleculeItem_atomcount::updateAtomCount, this),
            "MoleculeItem_atomcount_"+toString(_molid),
            updateAtomCount(),
            channellist_atomcount)
  {
    signOnToMolecule();
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  ~QtMoleculeItem_atomcount()
  {
    signOffFromMolecule();
  }

  int updateAtomCount() const
  {
    const molecule * const mol = getMolecule();
    if (mol != NULL)
      return mol->getAtomCount();
    else
      return -1;
  }

  /** Performs the update of the molecule's atomcount.
   *
   */
  void internal_updateState()
  {
    setText(QString::number(atomcount.get()));
  }

  QtMoleculeItem::COLUMNTYPES getType() const
  { return QtMoleculeItem::ATOMCOUNT; }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_atomcount;

  //!> temporary value for molecule
  const molecule * const molref;

  //!> contains visibility state
  ObservedValue<int> atomcount;
};



#endif /* QTMOLECULEITEM_ATOMCOUNT_HPP_ */
