/*
 * ShapeExceptions.hpp
 *
 *  Created on: Apr 1, 2011
 *      Author: heber
 */

#ifndef SHAPEEXCEPTIONS_HPP_
#define SHAPEEXCEPTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <exception>
#include <boost/exception.hpp>

class Vector;

/** Base type for all exceptions regarding linear algebra.
 *
 */
struct ShapeException : virtual std::exception, virtual boost::exception { };

/** ========================== General error information ================== */

/** Exception information for LinearAlgebraException: determinant.
 */
typedef boost::error_info<struct tag_ShapeVector, const Vector * const> ShapeVector;


/** ============================ Specific exceptions ====================== */

/** Exception thrown when two vectors are parallel, i.e. linear dependent.
 */
struct NotOnSurfaceException : virtual ShapeException { };


#endif /* SHAPEEXCEPTIONS_HPP_ */
